from pprint import pprint

# načtení názvů států ze souboru s plochami
plochy = {} # slovník
with open('staty_plochy.log') as soubor:
    for řádka in soubor:
        stát, plocha = řádka.rstrip('\n').split(': ')
        plochy[stát] = plocha   # pod klíčem stát bude jeho plocha

# načtení názvů států ze souboru s počtem obyvatel
lidi = {}   # slovník
with open('staty_lidi.log') as soubor:
    for řádka in soubor:
        stát, počet_obyvatel = řádka.rstrip('\n').split(': ')
        lidi[stát] = počet_obyvatel # pod klíčem stát bude jeho počet obyvatel

# Jaká je hustota obyvatel ve státě Togo?
print(f'Plocha: {plochy["Togo"]}')
print(f'Počet obyvatel: {lidi["Togo"]}')
print(f'Hustota zalidnění: {int(lidi["Togo"]) / float(plochy["Togo"])}')

'''
Plocha: 56785
Počet obyvatel: 5560000
Hustota zalidnění: 97.91318129787795
'''
